var TvShowStatus = { Unknown: 0, SeriesEnded: 1, Normal: 2 };

// Returns a string representation of a TvShowStatus
function tvShowStatusToString(tv_show_status)
{
    switch (tv_show_status)
    {
        case TvShowStatus.Unknown:     return "Unknown";
        case TvShowStatus.SeriesEnded: return "Ended";
        case TvShowStatus.Development: return "In Development";
        case TvShowStatus.Normal:      return "Normal";
    }

    return null;
}

var TvShowParser = Class.create();

// Parses a TV.com TV show summary page
TvShowParser.prototype =
{
initialize: function(quickInfo)
{
    var showinfo = JSON.parse(quickInfo);

    this.quickInfo = [];



    this.quickInfo.showName = showinfo.name;
    this.quickInfo.showUrl = showinfo.url;

    if (showinfo.image && showinfo.image.medium)
      this.quickInfo.image = showinfo.image.medium;

    this.quickInfo.episodeUrl = showinfo.url;
    this.quickInfo.premiered = showinfo.premiered;
    this.quickInfo.status = showinfo.status;
    this.quickInfo.classification = showinfo.type;
    this.quickInfo.genres = showinfo.genres.join();
    this.quickInfo.country = "?";
    if(showinfo.network)
    {
      this.quickInfo.network = showinfo.network.name;
      if(showinfo.network.country) this.quickInfo.country = showinfo.network.country.code;
      this.quickInfo.networkUrl = 'http://www.tvmaze.com/networks/'+showinfo.network.id;
      if(showinfo.network.country) this.quickInfo.timezone = showinfo.network.country.timezone;
    }
    else if(showinfo.webChannel)
    {
      this.quickInfo.network = showinfo.webChannel.name;
      if(showinfo.webChannel.country) this.quickInfo.country = showinfo.webChannel.country.code;
      this.quickInfo.networkUrl = 'http://www.tvmaze.com/webchannels/'+showinfo.webChannel.id;
      if(showinfo.webChannel.country) this.quickInfo.timezone = showinfo.webChannel.country.timezone;
    }
    if(showinfo.schedule && showinfo.schedule.days && showinfo.schedule.time) this.quickInfo.airtime = showinfo.schedule.days.join()+' at '+showinfo.schedule.time+' am';
    else if (showinfo.schedule && showinfo.schedule.time) this.quickInfo.airtime = showinfo.schedule.time;
    //if(showinfo._embedded && showinfo._embedded.previousepisode)
    //{
    //this.quickInfo.latestEpisode = [];
    //this.quickInfo.latestEpisode.episode = showinfo._embedded.previousepisode.season.toString()+'x'+showinfo._embedded.nextepisode.number.toString();
    //this.quickInfo.latestEpisode.title = showinfo._embedded.previousepisode.name;
    //this.quickInfo.latestEpisode.airDate = showinfo._embedded.previousepisode.airdate;
    //}
    if(showinfo._embedded && showinfo._embedded.nextepisode)
    {
    this.quickInfo.nextEpisode = [];
    this.quickInfo.nextEpisode.episode = showinfo._embedded.nextepisode.season.toString()+'x'+showinfo._embedded.nextepisode.number.toString();
    this.quickInfo.nextEpisode.title = showinfo._embedded.nextepisode.name;
    if (showinfo._embedded.nextepisode.airdate) this.quickInfo.nextEpisode.airDate = showinfo._embedded.nextepisode.airdate;//+' at '+showinfo._embedded.nextepisode.airtime+' am';
    if (showinfo._embedded.nextepisode.url) this.quickInfo.episodeUrl = showinfo._embedded.nextepisode.url;
  }

},

// The show title
showTitle: function()
{
    return this.quickInfo.showName;
},

// The show status
showStatus: function()
{
  if (this.quickInfo.status == "Running")
	{
	    return TvShowStatus.Normal;
	}
  else if (this.quickInfo.status == "Ended")
	{
	    return TvShowStatus.SeriesEnded;
	}
  else if (this.quickInfo.status == "In Development")
	{
	    return TvShowStatus.Development;
	}

    return TvShowStatus.Unknown;
},

// The next episode title
episodeTitle: function()
{
  if (!this.quickInfo.nextEpisode)
  {
    return null;
  }
  if (!this.quickInfo.nextEpisode.title)
  {
      return null;
  }

    return this.quickInfo.nextEpisode.title;
},

seasonNumber: function()
{
    if (this.quickInfo.nextEpisode.episode)
    {
        var episodeId = this.quickInfo.nextEpisode.episode;

				var seasonInfo = episodeId.split('x');

				if (seasonInfo.length == 2)
				{
						return parseInt(seasonInfo[0]);
				}
    }

    return null;
},

episodeNumber: function()
{
  if (this.quickInfo.nextEpisode.episode)
    {
        var episodeId = this.quickInfo.nextEpisode.episode;

				var seasonInfo = episodeId.split('x');

				if (seasonInfo.length == 2)
				{
						return parseInt(seasonInfo[1]);
				}
    }

    return null;
},

episodeUrl: function()
{
  if (this.quickInfo.episodeUrl)
    {
      return this.quickInfo.episodeUrl;
    }

    return null;
},


networkUrl: function()
{
  if (this.quickInfo.networkUrl)
    {
      return this.quickInfo.networkUrl+'/tvforecast';
    }

    return 'http://www.tvmaze.com/';
},


showImage: function()
{
  if (this.quickInfo.image)
    {
      return this.quickInfo.image;
    }

    return 'Images/null.png';
},


showUrl: function()
{
  if (this.quickInfo.showUrl)
    {
      return this.quickInfo.showUrl;
    }

    return null;
},

showSummary: function()
{
  var summary = "";

  if (this.quickInfo.premiered)
    {
      var premieredComponents = this.quickInfo.premiered.split('-');
      summary += premieredComponents[0];
    }

  if (this.quickInfo.genres)
    {
      summary += " (";
      summary += this.quickInfo.genres.replace(/,/g,', ');
      summary += ")";
    }
    else if (this.quickInfo.type)
      {
        summary += " (";
        summary += this.quickInfo.type;
        summary += ")";
      }
      if (summary.length > 24)
      {
          summary = summary.substr(0,23).replace(/\s*$/, '') + '…';
          summary += ")";
      }


    return summary;
},

airSummary: function()
{
  var summary = "";
  if (this.quickInfo.airtime)
    {
      summary += this.quickInfo.airtime.replace(' am','').replace(' at ',' @ ');
    }
    if (this.quickInfo.network)
      {
        summary += " - ";
        summary += this.quickInfo.network;
      }
      if (this.quickInfo.country && $('include-img-cb').checked)
        {
          summary += '  <img class="flag" src="Images/famfamfam-flags/';
          summary += this.quickInfo.country.toLowerCase();
          summary += '.png" />';
          //summary += " (";
          //summary += this.quickInfo.country;
          //summary += ")";
        }
        else if (this.quickInfo.country != "?")
          {
            summary += " (";
            summary += this.quickInfo.country;
            summary += ")";
          }

    return summary;
},




// When the show will air next
showAirsNext: function()
{
    this.quickInfo.includesTimeOfDay = false;

    var date = new Date();

    if (!this.quickInfo.nextEpisode)
    {
        return 'Unknown';
    }
    if (!this.quickInfo.nextEpisode.airDate)
    {
        return 'TBA';
    }

    //var airDateMatch = /^(.*?)\/(\d*?)\/(\d*?)$/.exec(this.quickInfo.nextEpisode.airDate);
    var airDateMatch = this.quickInfo.nextEpisode.airDate.split('-');

    if (airDateMatch)
    {
      var year = airDateMatch[0];
      var month = airDateMatch[1]-1;
      var day = airDateMatch[2];
      date.setFullYear(year, month, day);
//return date;
    }
    else
    {
        return null;
    }

    if (this.quickInfo.airtime)
    {
       var airTimeComponents = this.quickInfo.airtime.split(' at ');

       var airTime = '';

       if (airTimeComponents.length == 1)
       {
           airTime = this.quickInfo.airTime;
       }
       else
       {
           airTime = airTimeComponents[1];
       }

       var airTimeMatch = /(\d*?):(\d*?) (am|pm)/.exec(airTime);

       if (airTimeMatch)
       {
           var hours = parseInt(airTimeMatch[1], 10);
           var minutes = parseInt(airTimeMatch[2], 10);

           date.setHours(hours);
           date.setMinutes(minutes);
           date.setSeconds(0);
           date.setMilliseconds(0);

           this.quickInfo.includesTimeOfDay = true;
       }
    }

    return date;
},

getContinent: function()
{
  if(!this.quickInfo.timezone)
    return null;

  var tzComponents = this.quickInfo.timezone.split('/');
  for (var i = 0; i < continents.length; i++)
  {
    if(continents[i].continent == tzComponents[0])
    {
      this.continent = i;
      return i;
    }
  }
  return null;
},

getCity: function(continent)
{
  if(!this.quickInfo.timezone || !continent)
    return null;

  var tzComponents = this.quickInfo.timezone.split('/');
  for (var i = 0; i < continents[continent].cities.length; i++)
  {
    if(continents[continent].cities[i].city == tzComponents[1])
    {
      this.city = i;
      return i;
    }
  }
  return null;
},

getTimezone: function()
{
  if(!this.quickInfo.timezone)
    return null;

  return this.quickInfo.timezone;
},

// True if the time of day when the show will air next is known
includesTimeOfDay: function()
{
    return this.quickInfo.includesTimeOfDay;
}
}
